//
//  MCStringFormatter.h
//  FormatterTest
//
//  Created by Ali Lalani on Mon Jul 08 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//
// Subclass of NSFormatter
// Functionality:
// 	1. Prohibit input to specific character sets
//	2. Set maximum number of characters allowed
//	3. Set minimum number of characters(sends an error back which the controller needs to do something with)
//	4. Turn all alphabetical characters to lowercase
//	5. Turn all alphabetical characters to uppercase
//	6. Capitalize the first letter of every word
//      7. Clear whitespace from the front of the string
//      8. Clear whitespace from the end of the string

#import <Foundation/Foundation.h>
 
#define ALLUPPERCASE 0
#define CAPITALIZEDCASE 1
#define ALLLOWERCASE 2
#define NONE 3
// ALLUPPERCASE    = all letters in the string are turned to upper case
// CAPITALIZEDCASE = capitalize the first letter of each word in the string
// ALLLOWERCASE    = all letters in the string are turned to lower case
// NONE            = no restriction on case(default)

@interface MCStringFormatter : NSFormatter {
	int currentCasePreference;

    int lowerBound,upperBound;              // must be over lowerBound and over upperBound characters long(0 for no bound)
    NSMutableArray *charSetArray;
    NSString *charSetString;
    NSString *lastValidInput;               // each time the text is entered and valid the string goes into this value

    // these are the flags for the Character Sets(see NSCharacterSet)
    BOOL allowAlphanumeric;
    BOOL allowControl;
    BOOL allowDecimalDigit;
    BOOL allowDecomposable;
    BOOL allowIllegal;
    BOOL allowLetter;
    BOOL allowNonBase;
    BOOL allowPunctuation;
    BOOL allowWhitespace;
    BOOL allowWhitespaceAndNewline;
    BOOL allowOther;                 // this flag must be used in conjunction with charSetString
                                     // if set to YES, charSetString should contain some characters
}

- (void)commonInit;
- (BOOL)compareCharSetArrayWithString:(NSString *)theString;  // goes through charSetArray, if the string passes, it sends back yes, otherwise no

// accessor methods
- (void)setCurrentCasePreference:(int)pref;
- (int)currentCasePreference;

- (void)setLowerBound:(int)num;
- (int)lowerBound;

- (void)setUpperBound:(int)num;
- (int)upperBound;

- (void)setCharSetString:(NSString *)theString;
- (NSString *)charSetString;

- (void)setLastValidInput:(NSString *)theString;
- (NSString *)lastValidInput;

- (void)resetCharSetArray; // runs through all the booleans and re-creates the charSetArray based on them

// Character Set boolean accessor methods
- (void)setAllowAlphanumeric:(BOOL)setchoice;
- (BOOL)allowAlphanumeric;

- (void)setAllowControl:(BOOL)setchoice;
- (BOOL)allowControl;

- (void)setAllowDecimalDigit:(BOOL)setchoice;
- (BOOL)allowDecimalDigit;

- (void)setAllowDecomposable:(BOOL)setchoice;
- (BOOL)allowDecomposable;

- (void)setAllowIllegal:(BOOL)setchoice;
- (BOOL)allowIllegal;

- (void)setAllowLetter:(BOOL)setchoice;
- (BOOL)allowLetter;

- (void)setAllowNonBase:(BOOL)setchoice;
- (BOOL)allowNonBase;

- (void)setAllowPunctuation:(BOOL)setchoice;
- (BOOL)allowPunctuation;

- (void)setAllowWhitespace:(BOOL)setchoice;
- (BOOL)allowWhitespace;

- (void)setAllowWhitespaceAndNewline:(BOOL)setchoice;
- (BOOL)allowWhitespaceAndNewline;

- (void)setAllowOther:(BOOL)setchoice;
- (BOOL)allowOther;

- (void)setCharSetString:(NSString *)theString;
- (NSString *)charSetString;
@end
